{========================================================================}
{=                (c) 1995-98 SwiftSoft Ronald Dittrich                 =}
{========================================================================}
{=                          All Rights Reserved                         =}
{========================================================================}
{=  D 01099 Dresden             = Fax.: +49(0)351-8037944               =}
{=  Loewenstr.7a                = info@swiftsoft.de                     =}
{========================================================================}
{=  Actual versions on http://www.swiftsoft.de/index.html               =}
{========================================================================}
{=  This code is for reference purposes only and may not be copied or   =}
{=  distributed in any format electronic or otherwise except one copy   =}
{=  for backup purposes.                                                =}
{=                                                                      =}
{=  No Delphi Component Kit or Component individually or in a collection=}
{=  subclassed or otherwise from the code in this unit, or associated   =}
{=  .pas, .dfm, .dcu, .asm or .obj files may be sold or distributed     =}
{=  without express permission from SwiftSoft.                          =}
{=                                                                      =}
{=  For more licence informations please refer to the associated        =}
{=  HelpFile.                                                           =}
{========================================================================}
{=  $Date: 11.01.99 - 17:17:43 $                                        =}
{========================================================================}
unit Unit1;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs,
  StdCtrls, MMObj, MMDIBCv, MMLevel, MMConect, MMHook, MMDesign, MMDSPObj,
  MMUtils, MMWavOut, MMAudio, MMSlider, ExtCtrls, MMWave, MMACMCvt,
  MMMPEG, MMPitch, MMSystem;

type
  TForm1 = class(TForm)
    WaveOut: TMMWaveOut;
    MMDesigner1: TMMDesigner;
    OpenDialog: TOpenDialog;
    MMConnector1: TMMConnector;
    MMLevel1: TMMLevel;
    MMLevel2: TMMLevel;
    btnPlay: TButton;
    btnStop: TButton;
    btnFade: TButton;
    Slider: TMMSlider;
    Timer1: TTimer;
    AudioFile: TMMAudioFile;
    Pitch: TMMPitch;
    Label1: TLabel;
    Slider2: TMMSlider;
    Label2: TLabel;
    RadioGroup1: TRadioGroup;
    procedure FormClose(Sender: TObject; var Action: TCloseAction);
    procedure btnPlayClick(Sender: TObject);
    procedure btnStopClick(Sender: TObject);
    procedure WaveOutStop(Sender: TObject);
    procedure WaveOutStart(Sender: TObject);
    procedure btnFadeClick(Sender: TObject);
    procedure SliderTrack(Sender: TObject);
    procedure SliderTrackEnd(Sender: TObject);
    procedure Timer1Timer(Sender: TObject);
    procedure Slider2Change(Sender: TObject);
    procedure WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
  private
    Seeking: Boolean;
  public
  end;

var
  Form1: TForm1;

implementation

{$R *.DFM}

(*

 This demo demonstrates how to play only the left or right channel of a file
 on both stereo channels of a soundcard.

*)

{------------------------------------------------------------------------------}
procedure TForm1.FormClose(Sender: TObject; var Action: TCloseAction);
begin
   WaveOut.Close;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStart(Sender: TObject);
begin
   btnPlay.Enabled := False;
   btnStop.Enabled := True;
   btnFade.Enabled := True;
   Slider.Enabled  := True;
   Timer1.Enabled := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutStop(Sender: TObject);
begin
   WaveOut.Close;
   btnPlay.Enabled := True;
   btnStop.Enabled := False;
   btnFade.Enabled := False;
   Timer1.Enabled := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnPlayClick(Sender: TObject);
begin
   if (AudioFile.FileName = '') and OpenDialog.Execute then
   begin
      AudioFile.FileName := OpenDialog.FileName;
      Slider.MaxValue := AudioFile.PlayLength;
      WaveOut.Start;
   end
   else if not AudioFile.Empty then
   begin
      AudioFile.Position := Slider.Position;
      WaveOut.Start;
   end;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnStopClick(Sender: TObject);
begin
   WaveOut.Stop;
end;

{------------------------------------------------------------------------------}
procedure TForm1.btnFadeClick(Sender: TObject);
begin
   AudioFile.FadeOut(5000);
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrack(Sender: TObject);
begin
   Seeking := True;
end;

{------------------------------------------------------------------------------}
procedure TForm1.SliderTrackEnd(Sender: TObject);
begin
   if (wosOpen in WaveOut.State) then
   begin
      WaveOut.Pause;
      AudioFile.Position   := Slider.Position;
      WaveOut.Reset;
      WaveOut.Restart;
   end;
   Seeking := False;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Timer1Timer(Sender: TObject);
begin
   if not Seeking then
      Slider.Position := AudioFile.Position;
end;

{------------------------------------------------------------------------------}
procedure TForm1.Slider2Change(Sender: TObject);
begin
   Pitch.Pitch := Slider2.Position;
end;

{------------------------------------------------------------------------------}
procedure TForm1.WaveOutBufferFilled(Sender: TObject; lpWaveHdr: PWaveHdr);
type
   PChannel = ^TChannel;
   TChannel = record
     Left : Smallint;
     Right: Smallint;
   end;
   PChannels = ^TChannels;
   TChannels = array[0..0] of TChannel;
var
   i: integer;
   lpData: PChannels;
   dwCount: DWORD;
begin
   // Waveout has loaded the data, our last chance to modify it
   // before it is send to the driver.
   if (RadioGroup1.ItemIndex > 0) then
   begin
      // this works only with stereo PCM data !
      if (WaveOut.PWaveFormat^.wFormatTag = WAVE_FORMAT_PCM) and
         (WaveOut.PWaveFormat^.nChannels = 2) then
      begin
         lpData  := PChannels(lpWaveHdr^.lpData);
         dwCount := lpWaveHdr^.dwBytesRecorded div 4; // length in stereo samples

         if (RadioGroup1.ItemIndex = 1) then
         begin
            // play the left channel on the right channel too
            for i := 0 to dwCount-1 do
               lpData[i].Right := lpData[i].Left;
         end
         else
         begin
            // play the right channel on the left channel too
            for i := 0 to dwCount-1 do
               lpData[i].Left := lpData[i].Right;
         end;
      end;
   end;
end;

end.


